(defun c:pcr()
   (prompt "\nEntity/Point (E or P):")
   (while (/= 2 (car (setq Pick (grread)))))
   (setq Kb (cadr Pick))
   (if (or (= Kb (ascii "e")) (= Kb (ascii "E")))
      (setq S1 (entsel "\nSelect an Arc, Circle or Line:")
            Pp (getpoint "\nPoint:")
            A t
      )
      (setq Pp (getpoint "\nPoint:")
            S1 (entsel "\nSelect Arc, Circle or Line:")
            A nil
      )
   )
   (setq l1 (entget (car S1))
         P1 (cadr S1)
         Ent (cdr (assoc 0 l1))
         E (= 0 R)
   )
   (if (= Ent "LINE")
      (if E
         (*error* "\nIt is impossible to tangent a line !!!")
         (progn
            (setq E1 (cdr (assoc 10 l1))
                  E2 (cdr (assoc 11 l1))
                  Len (distance E1 E2)
                  Pm (Lp E1 E2 Pp)
                  L (distance Pp Pm)
                  A0 (angle E1 E2)
                  A1 (- (angle Pm Pp) A0)
                  A2 (- (angle Pm P1) A0)
            )
            (if (< 0 (sin A1))
               (setq Y R) (setq Y (- 0 R))
            )
            (if (< 0 (cos A2))
               (setq X (sqrt (- (* 2 L R) (* L L))))
               (setq X (- 0 (sqrt (- (* 2 L R) (* L L)))))
            )
            (setq Pc (polar Pm (+ A0 (atan Y X)) (sqrt (+ (* X X) (* Y Y))))
                  P11 (polar Pc (angle Pp Pm) R)
                  L1 (distance P11 E1)
                  L2 (distance P11 E2)
                  A3 (angle Pc P11)
                  B (< 0 (sin (- (angle Pc E1) A3)))
            )
            (if (and (> Len L1) (> Len L2))
               (if (or (and (null A) B) (and A (null B)))
                  (command "erase" P1 "" "line" E1 P11 "")
                  (command "erase" P1 "" "line" E2 P11 "")
               )
               (if (or (and (null A) B) (and A (null B)))
                  (command "change" E1 "" P11)
                  (command "change" E2 "" P11)
               )
            )
         )
      )
      (progn
         (setq C1 (cdr (assoc 10 l1))
               R1 (cdr (assoc 40 l1))
               L (distance C1 Pp)
               A0 (angle C1 Pp)
               D (> R1 L)
         )
         (setq A1 (- (angle C1 P1) A0))
         (setq C (< 0 (cos A1)))
         (if (or D (null C))
            (setq R1 (- 0 R1))
         )
         (if E
            (setq X (/ (* R1 R1) L))
            (setq X (/ (+ (* R1 R1) (* L L) (* 2 R1 R)) 2. L))
         )
         (setq R2 (+ R1 R)
               Y (sqrt (- (* R2 R2) (* X X)))
               B (< 0 (sin A1))
         )
         (if (or (and (or (and (null B) D) (and B (null C) (null D))
                          (and (null B) C (null D))
                      )
                      (null E)
                 )
                 (and E (null B))
             )
            (setq Y (- 0 Y))
         )
         (setq Pc (polar C1 (+ A0 (atan Y X)) (sqrt (+ (* X X) (* Y Y)))))
         (if E
            (setq P11 Pc)
            (if D
               (setq P11 (polar Pc (angle C1 Pc) R))
               (setq P11 (polar Pc (angle Pc C1) R))
            )
         )
         (command "erase" P1 "")
         (if (= Ent "CIRCLE")
            (if (or (and (or (and A C (null D)) (and D (null A))
                             (and (null A) (null C) (null D))
                         )
                         (null E)
                    )
                    (and E B)
                )
               (command "arc" P11 "c" C1 "a" 180)
               (command "arc" P11 "c" C1 "a" -180)
            )
            (progn
               (setq A3 (cdr (assoc 50 l1))
                     A4 (cdr (assoc 51 l1))
                     R1 (abs R1)
               )
               (if (or (and (or (and A C (null D)) (and D (null A))
                                (and (null A) (null C) (null D))
                            )
                            (null E)
                       )
                       (and E B)
                   )
                  (command "arc" P11 "c" C1 (polar C1 A4 R1))
                  (command "arc" (polar C1 A3 R1) "c" C1 P11)
               )
            )
         )
      )
   )
   (if E
      (command "line" P11 Pp "")
      (if A (command "arc" P11 "c" Pc Pp)
            (command "arc" Pp "c" Pc P11)
      )
   )
)
